// Glenn's POV-Ray Lights File
// created 20-June-96
//
// Copyright 2005 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 

// using English coordinate system -- basic unit is Inches
#declare Foot = 12
#declare Feet = 12
#declare Mile = 12*5280
#declare Miles = 12*5280

#declare StdLight =
  light_source { 
    <0,0,0>
    colour rgb <.95, .95, .95>
    looks_like {
      sphere {
        <0,0,0>, 18
        texture {
          pigment { color White }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

// NOTE - StdSpot requires an input vector
// to set the point_at position.
// use "#declare Sx = 12" ,etc.
#declare StdSpot =
  light_source { 
    <0,0,0>
    colour rgb <1, 1, 1>
    spotlight
    point_at <Sx,Sy,Sz>
    radius 18    // degrees fully lit (*2)
    falloff 24   // degrees no lighting (*2)
    tightness 1

    looks_like {
      sphere {
        <0,0,0>, 4
        texture {
          pigment { color White }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare StdRoomLight =
  light_source { 
    <0,0,0>
    colour rgb <.95, .95, .95>
    looks_like {
      sphere {
        <0,0,0>, 4
        texture {
          pigment { color White }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare StdRoomLight100 =
  light_source { 
    <0,0,0>
    colour rgb <1, 1, 1>
    looks_like {
      sphere {
        <0,0,0>, 4
        texture {
          pigment { color White }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
#declare StdRoomLight75 =
  light_source { 
    <0,0,0>
    colour rgb <.75, .75, .75>
    looks_like {
      sphere {
        <0,0,0>, 4
        texture {
          pigment { color White }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare StdRoomLight50 =
  light_source { 
    <0,0,0>
    colour rgb <.5, .5, .5>
    looks_like {
      sphere {
        <0,0,0>, 4
        texture {
          pigment { color White }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
#declare StdRoomLight35 =
  light_source { 
    <0,0,0>
    colour rgb <.35, .35, .35>
    looks_like {
      sphere {
        <0,0,0>, 4
        texture {
          pigment { color White }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
